﻿using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.AdvancedAPI.Sample4
{
    public partial class FormMain : Form
    {
        private const int SC_CLOSE = 0xF060;
        private const int MF_Grayed = 0x1;
        private const int MF_Enabled = 0x0;

        [DllImport("user32.dll")]
        public static extern bool EnableMenuItem(IntPtr hMenu, int uIDEnableItem, int uEnable);

        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        public enum CallbackCommand
        {
            Progress = 0x0,
            DownWithStructure = 0x1,
            InSufficientRights = 0x6,
            DiskLockedForAccess = 0x7,
            Done = 0xB,
            Output = 0xE,
            StructureProgress = 0xF
        }

        public delegate Int32 FormatCallBackDelegate(CallbackCommand callBackCommand, int subActionCommand, IntPtr action);

        [DllImport("fmifs.dll", EntryPoint = "FormatEx", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern void FormatEx(string driveLetter, int mediaFlag, string fsType, string label, bool quickFormat, Int32 clusterSize, FormatCallBackDelegate callBackDelegate);

        public const int FMIFS_HardDisk = 0xC;
        public const int FMIFS_Removeable = 0xB;
        public int VolumeType;

        private static Int32 FormatCallBack(CallbackCommand callBackCommand, int subActionCommand, IntPtr action)
        {
            Application.DoEvents();

            switch (callBackCommand)
            {
                case CallbackCommand.Progress:
                    string percent = Convert.ToString(action);
                    break;
                case CallbackCommand.Done:
                    string status = Convert.ToString(action);
                    MessageBox.Show("Format complete.", "Format", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    break;
            }
            return 1;
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            GetDriveList();
            comboBoxClusterSize.SelectedIndex = 0;
        }

        private void ButtonCloseClick(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void ButtonStartClick(object sender, EventArgs e)
        {
            if (MessageBox.Show("Warning: Formating will erase all data on the selected Drive.\nAre you sure you want to format?", @"Format", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) != DialogResult.Yes)
                return;
            string driveName = comboBoxDriveList.Text.Substring(0, 2);
            string volumeLable = textBoxLable.Text;
            string fileSystem = comboBoxFileSystem.Text;
            Int32 clusterSize = comboBoxClusterSize.Text == @"Default" ? 0 : Convert.ToInt32(comboBoxClusterSize.Text);
            EnabledControl(false);
            progressBarFormat.Style = ProgressBarStyle.Marquee;
            FormatCallBackDelegate formatCallBackDelegate = FormatCallBack;
            FormatEx(driveName, VolumeType, fileSystem, volumeLable, checkBoxQuickFormat.Checked, clusterSize, formatCallBackDelegate);
            progressBarFormat.Style = ProgressBarStyle.Blocks;
            EnabledControl(true);
        }

        private void ComboBoxDriveListSelectedIndexChanged(object sender, EventArgs e)
        {
            GetDriveInfo();
        }

        private void GetDriveList()
        {
            DriveInfo[] allDrive = DriveInfo.GetDrives();
            foreach (DriveInfo drive in allDrive)
            {
                comboBoxDriveList.Items.Add(drive.Name);
            }
            comboBoxDriveList.SelectedIndex = 0;
        }

        private void GetDriveInfo()
        {
            DriveInfo[] allDrive = DriveInfo.GetDrives();
            try
            {
                foreach (DriveInfo d in allDrive)
                {
                    if (d.Name != comboBoxDriveList.Text) continue;
                    labelCapacity.Text = string.Format("{0:N2} GB", (d.TotalSize) / Math.Pow(2, 30));
                    comboBoxFileSystem.Text = d.DriveFormat;
                    textBoxLable.Text = d.VolumeLabel;
                    switch (d.DriveType)
                    {
                        case DriveType.Fixed:
                            VolumeType = FMIFS_HardDisk;
                            break;
                        case DriveType.Removable:
                            VolumeType = FMIFS_Removeable;
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, @"Error");
            }
        }

        private void EnabledControl(bool flag)
        {
            buttonClose.Enabled = flag;
            buttonStart.Enabled = flag;
            comboBoxClusterSize.Enabled = flag;
            comboBoxDriveList.Enabled = flag;
            comboBoxFileSystem.Enabled = flag;
            checkBoxQuickFormat.Enabled = flag;
            textBoxLable.Enabled = flag;
            EnableMenuItem(GetSystemMenu(Handle, false), SC_CLOSE, flag ? MF_Enabled : MF_Grayed);
        }
    }
}